<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;
use Illuminate\Http\UploadedFile;

class FileExtension implements ValidationRule
{
    public function __construct(
        private array $allowedExtensions
    ) {}

    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        if (!$value instanceof UploadedFile) {
            $fail('El archivo no es válido');
            return;
        }

        // Obtener extensión del nombre original del archivo
        $originalName = $value->getClientOriginalName();
        $extension = strtolower(pathinfo($originalName, PATHINFO_EXTENSION));

        if (!in_array($extension, $this->allowedExtensions)) {
            $fail("El archivo debe ser de tipo: " . implode(', ', $this->allowedExtensions));
        }
    }
}
