<?php

namespace App\Models;

use App\Traits\QueryScopeTrait;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Province extends Model
{
    use HasFactory, QueryScopeTrait;

    protected $fillable = [
        'name',
        'department_id',
    ];

    // Columnas donde se puede buscar (texto general)
    public array $searchable = ['name'];

    // Columnas por las que se puede ordenar
    public array $sortable = ['id', 'name'];

    // Relaciones que se pueden incluir
    public array $allowedIncludes = ['department', 'districts'];

    // Columnas por las que se puede filtrar específicamente
    public array $filterable = ['department_id', 'name'];

    // Relaciones
    public function department()
    {
        return $this->belongsTo(Department::class);
    }

    public function districts()
    {
        return $this->hasMany(District::class);
    }
}
