<?php

namespace App\Models;

use App\Traits\QueryScopeTrait;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DiscountType extends Model
{
    use HasFactory, QueryScopeTrait;

    protected $fillable = [
        'name',
        'description',
        'amount',
        'active',
    ];

    protected $casts = [
        'active' => 'boolean',
    ];

    // Columnas donde se puede buscar (texto general)
    public array $searchable = ['name', 'description'];

    // Columnas por las que se puede ordenar
    public array $sortable = ['id', 'name', 'description'];

    // Relaciones que se pueden incluir
    public array $allowedIncludes = ['enrollments'];

    // Columnas por las que se puede filtrar específicamente
    public array $filterable = ['active', 'name'];

    public function enrollments()
    {
        return $this->hasMany(Enrollment::class);
    }
}
