<?php

namespace App\Models;

use App\Traits\QueryScopeTrait;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Country extends Model
{
    use HasFactory, QueryScopeTrait;

    protected $fillable = [
        'name'
    ];

    // Columnas donde se puede buscar (texto general)
    public array $searchable = ['name'];

    // Columnas por las que se puede ordenar
    public array $sortable = ['id', 'name'];

    // Relaciones que se pueden incluir
    public array $allowedIncludes = ['departments'];

    // Columnas por las que se puede filtrar específicamente
    public array $filterable = ['id', 'name'];

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];


    //
    public function departments()
    {
        return $this->hasMany(Department::class);
    }
}
