<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class EnrollmentResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'student_id' => $this->student_id,
            'cycle_id' => $this->cycle_id,
            'career_id' => $this->career_id,
            'status' => $this->status?->value,

            // Datos de registro
            'oath_declaration' => $this->oath_declaration,
            'grade_school' => $this->grade_school,
            'file_grade_school' => $this->file_grade_school,
            'score' => $this->score,
            'classroom_id' => $this->classroom_id,

            // Metadata
            'registration_steps' => $this->registration_steps,
            'information_sources' => $this->information_sources,

            // Pago y descuentos
            'total_amount' => $this->total_amount,
            'payment_type' => $this->payment_type?->value,
            'discount_type_id' => $this->discount_type_id,
            'discount_amount' => $this->discount_amount,
            'discount_file' => $this->discount_file,
            "total_amount_pending" => $this->total_amount_pending,

            // Relaciones (solo si están cargadas)
            'cycle' => CycleResource::make($this->whenLoaded('cycle')),
            'career' => CareerResource::make($this->whenLoaded('career')),
            'classroom' => ClassroomResource::make($this->whenLoaded('classroom')),
            'discount_type' => DiscountTypeResource::make($this->whenLoaded('discountType')),
            'payments' => PaymentResource::collection($this->whenLoaded('payments')),
        ];
    }
}
