<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class SchoolRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    //Get the validation rules that apply to the request.

    public function rules(): array
    {
        $id = $this->route("id");
        return [
            "code" => [
                "required",
                "string",
                "min:3",
                "max:20",
                Rule::unique("schools", "code")->ignore($id)
            ],
            "name" => [
                "required",
                "string",
                "min:3",
                "max:100",
                Rule::unique("schools", "name")->ignore($id)
            ],
            "sector" => [
                "required",
                "string",
            ],
            "level" => [
                "required",
                "string",
            ],
            "ugel" => [
                "required",
                "string",
                "min:3",
                "max:100"
            ],
            "district_id" => [
                "required",
            ]
        ];
    }

    public function attributes(): array
    {
        return [
            "code" => "Código de la Escuela",
            "name" => "Nombre de la Escuela",
            "sector" => "Sector",
            "level" => "Nivel Educativo",
            "ugel" => "UGEL",
            "district_id" => "Distrito",
        ];
    }
}
