<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class RoleRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        // $roleId = $this->route('role')?->id;
        $roleId = $this->route('id');

        return [
            'name' => ['required', 'string', 'min:3', 'max:100', Rule::unique('roles', 'name')->ignore($roleId)],
            'slug' => [
                'required',
                'string',
                'min:3',
                'max:100',
                'regex:/^[a-z0-9._-]+$/',
                Rule::unique('roles', 'slug')->ignore($roleId),
            ],
            'description' => ['nullable', 'string', 'max:500'],
            'active' => ['required', 'boolean'],
        ];
    }

    public function attributes(): array
    {
        return [
            'name' => 'Nombre',
            'slug' => 'Identificador',
            'description' => 'Descripción',
            'active' => 'Activo',
        ];
    }
}
