<?php

namespace App\Http\Requests\Enrollment;

use Illuminate\Foundation\Http\FormRequest;
use App\Rules\FileExtension;

class PaymentDataRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'method' => ['nullable', 'in:box,transfer,other'],
            // 'enrollment_id' => ['required', 'exists:enrollments,id'],
            'payment_date' => ['required', 'date'],
            'amount' => ['required', 'numeric'],
            'receipt_number' => ['required', 'string', 'min:4', 'max:100', 'unique:payments,receipt_number'],
            'document_number' => ['nullable', 'string', 'min:8', 'max:20'],
            'full_name' => ['nullable', 'string', 'min:2', 'max:255'],
            'comment' => ['nullable', 'string', 'min:2', 'max:255'],
            'file' => [
                'required',
                'file',
                'max:5000', // 5MB
                new FileExtension(['pdf', 'jpg', 'jpeg', 'png']),
            ],
            'status' => ['nullable', 'in:pending,approved,rejected'],
            'approved_by' => ['nullable', 'exists:users,id'],
        ];
    }

    public function attributes(): array
    {
        return [
            'method' => 'Método de pago',
            // 'enrollment_id' => 'ID de matrícula',
            'payment_date' => 'Fecha de pago',
            'amount' => 'Monto',
            'receipt_number' => 'Número de recibo',
            'document_number' => 'Número de documento',
            'full_name' => 'Nombre completo',
            'comment' => 'Comentario',
            'file' => 'Archivo',
            'status' => 'Estado',
            'approved_by' => 'Aprobado por',
        ];
    }
}
