<?php

namespace App\Http\Requests\Enrollment;

use Illuminate\Foundation\Http\FormRequest;

class CareerDataRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'career_id' => ['required', 'exists:careers,id'],
            'information_sources' => ['required', 'array'],
        ];
    }

    public function attributes(): array
    {
        return [
            'career_id' => 'Carrera',
            'information_sources' => 'Medios de Información',
        ];
    }
}
