<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class DistrictRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    //Get the validation rules that apply to the request.

    public function rules(): array
    {
        $id = $this->route("id");
        return [
            "name" => [
                "required",
                "string",
                "min:3",
                "max:50",
                Rule::unique("districts", "name")->ignore($id)
            ],
            "province_id" => [
                "required",
            ]
        ];
    }

    public function attributes(): array
    {
        return [
            "name" => "Nombre del Distrito",
            "province_id" => "Provincia",
        ];
    }
}
