<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class DiscountTypeRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        $id = $this->route("id");
        return [
            "name" => [
                "required",
                "string",
                "min:3",
                "max:100",
                Rule::unique("discount_types", "name")->ignore($id)
            ],
            "description" => [
                "required",
                "string",
                "min:3",
                "max:100",
            ],
            "amount" => [
                "required",
                "numeric",
                "min:0"
            ],
            "active" => [
                "required",
                "boolean"
            ]
        ];
    }

    public function attributes(): array
    {
        return [
            "name" => "Nombre",
            "description" => "Descripción",
            "amount" => "Monto",
            "active" => "Activo"
        ];
    }
}
