<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class CycleRequest extends FormRequest
{
    // Determine if the user is authorized to make this request.
    public function authorize(): bool
    {
        return true;
    }

    // Reglas de validación que se aplicarán a la petición
    public function rules(): array
    {
        $id = $this->route('id');
        return [
            'name' => [
                'required',
                'string',
                'min:3',
                'max:50',
                Rule::unique('cycles', 'name')->ignore($id),
            ],
            'year' => [
                'required',
                'integer',
                'min:1900',
                'max:2100',
            ],
            'enrollment_open' => ['required', 'boolean'],
            'active' => ['required', 'boolean'],
            'enrollment_start_date' => ['required', 'date', 'before:enrollment_end_date'],
            'enrollment_end_date' => ['required', 'date', 'after:enrollment_start_date'],
            'full_payment_cost' => ['required', 'numeric', 'min:0'],
            'installment_cost' => ['required', 'numeric', 'min:0'],
        ];
    }

    // Mensajes de validación
    public function attributes(): array
    {
        return [
            'name' => 'Nombre del Ciclo',
            'year' => 'Año',
            'enrollment_open' => 'Abierta la inscripción',
            'active' => 'Estado',
            'enrollment_start_date' => 'Fecha inicio inscripción',
            'enrollment_end_date' => 'Fecha fin inscripción',
            'full_payment_cost' => 'Costo pago completo',
            'installment_cost' => 'Costo pago fraccionado',
        ];
    }
}
