<?php

namespace App\Http\Controllers\Api\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\IndexQueryRequest;
use App\Http\Resources\EnrollmentResource;
use App\Models\Enrollment;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class EnrollmentController extends Controller
{

    private array $messages = [
        'index'          => 'Listado de matrículas obtenidos',
        'store'          => 'Matrícula creada exitosamente',
        'show'           => 'Matrícula obtenida exitosamente',
        'update'         => 'Matrícula actualizada exitosamente',
        'destroy'        => 'Matrícula eliminada exitosamente',
        'not_found'      => 'Matrícula no encontrada',
        'cannot_destroy' => 'No se puede eliminar la matrícula',
    ];

    // Listar matriculas de un ciclo
    public function index(IndexQueryRequest $request, $cycleId): JsonResponse | EnrollmentResource
    {
        $enrollments = Enrollment::query()
            ->where('cycle_id', $cycleId)
            ->included()
            ->searchRelations()
            ->filter()
            ->sort()
            ->paginated();

        return EnrollmentResource::collection($enrollments)
            ->additional([
                'success' => true,
                'message' => $this->messages['index']
            ])
            ->response();
    }

    // Ver detalle de una matrícula
    public function show($cycleId, $enrollmentId)
    {
        $enrollment = Enrollment::query()
            ->included()
            ->findOrAbort($enrollmentId, $this->messages['not_found']);

        return EnrollmentResource::make($enrollment)->additional([
            'success' => true,
            'message' => $this->messages['show']
        ]);
    }
    // public function update($cycleId, $enrollmentId)      // Editar matrícula
    // public function toggleStatus($cycleId, $enrollmentId) // Cambiar estado
}
