<?php

namespace App\Enums;

enum PaymentType: string
{
    case Full = 'full'; // Pago completo
    case Installment = 'installment'; // Pago fraccionado

    public static function values(): array
    {
        return array_column(self::cases(), 'value');
    }

    public function label(): string
    {
        return match ($this) {
            self::Full => 'Pago completo',
            self::Installment => 'Pago fraccionado',
        };
    }
}
