<?php

namespace App\Enums;

enum MaritalStatus: string
{
    case Single = 'single';
    case Married = 'married';
    case Divorced = 'divorced';
    case Cohabitant = 'cohabitant';
    case Widowed = 'widowed';

    public static function values(): array
    {
        return array_column(self::cases(), 'value');
    }

    public function label(): string
    {
        return match ($this) {
            self::Single => 'Soltero(a)',
            self::Married => 'Casado(a)',
            self::Divorced => 'Divorciado(a)',
            self::Cohabitant => 'Conviviente',
            self::Widowed => 'Viudo(a)',
        };
    }
}
