<?php

namespace App\Enums;

enum GradeSchool: string
{
    case First = 'first';
    case Second = 'second';
    case Third = 'third';
    case Fourth = 'fourth';
    case Fifth = 'fifth';

    public static function values(): array
    {
        return array_column(self::cases(), 'value');
    }

    public function label(): string
    {
        return match ($this) {
            self::First => 'Primero',
            self::Second => 'Segundo',
            self::Third => 'Tercero',
            self::Fourth => 'Cuarto',
            self::Fifth => 'Quinto',
        };
    }
}
